
## Evolving Enterprise Environment

- The traditional enterprise network perimeter is becoming obsolete.
- Employees demand mobile device usage for work, anytime and anywhere.
- The average user utilizes three devices for corporate network access.
- More connected devices increase the attack surface for enterprises.
- Increased use of SaaS and virtualization complicates secure authentication and authorization.
## Balancing Security and Productivity

- IT departments must balance network, system, and application security with employee productivity.
- A new approach is needed for managing and securing the mobile enterprise.


Cisco IAM Solution - ***Cisco ISE***

## Enhanced User and Device Visibility

- IAM solutions provide superior visibility and control from a central location.
- Cisco Identity Services Engine (ISE) is an example of an IAM solution.

## Contextual Network Information

- IAM platforms enhance authentication and authorization with contextual network information.
- Contextual information includes:
    - **User Attributes**: Username, IP address, authentication status, location.
    - **User Class**: Authorization group, guest, quarantined.
    - **Device Attributes**: Manufacturer, model, OS, MAC address, network connection method, location.
    - **Posture**: Compliance status of the endpoint device, including antivirus and OS patch level.

## Benefits of Contextual Attributes

- Precise user and device identification.
- Simplified device provisioning.
- Centralized policy management for user access control.
- Integration with other solutions for faster threat response.

## IAM Policy Flow

- **Initial Access**: Endpoint attempts network access through a Network Access Device (NAD).
- **Authentication Challenge**: User authentication via 802.1X technology.
- **Authorization Policy**: Selected based on authentication characteristics and communicated to NAD.
- **Profiling and Authorization**:
    - New devices initially receive a policy for unknown devices.
    - Post-profiling, a new policy is assigned and communicated via a Change of Authorization (CoA) message.
    - Profiler results are stored in the internal endpoint database.

## Posturing Services

- Initial post-authentication does not grant full access.
- Posture assessment determines compliance, leading to possible policy upgrades.
- Changes conveyed to NAD using CoA messages.

# Cisco Ecosystem Integration

## ***Cisco Platform Exchange Grid (pxGrid)***

- Provides secure communication to share context information with Cisco ISE and partners.
- Acts as a controller for client authentication and authorization.
- Example: Cisco Secure Firewall Management Center can limit user access based on Active Directory membership.